//======================================
//GoldWindows.js
//======================================
/*:
 * @plugindesc 金額ウィンドウ表示処理
 * @author TRS
 *
 *
 * @param ======メイン設定=======
 * @desc セパレータ
 *
 * @param ウィンドウX座標
 * @desc ウィンドウの横座標
 * @type number
 * @max 816
 * @min -816
 * @default 636
 *
 * @param ウィンドウY座標
 * @desc ウィンドウの縦座標
 * @type number
 * @max 624
 * @min -624
 * @default 0
 *
 * @param ウィンドウ幅
 * @desc ウィンドウの横幅
 * @type number
 * @max 816
 * @min -816
 * @default 180
 *
 * @param ウィンドウ高さ
 * @desc ウィンドウの縦幅
 * @type number
 * @max 624
 * @min -624
 * @default 80
 *
 * @param 所持金文字
 * @type string
 * @desc 所持金文字の文言(翻訳用)
 * @default 所持金
 *
 * @param 表示・非表示スイッチ
 * @desc 借金ウィンドウ表示・非表示SW（日付ウィンドウと同じ番号にしたら一緒に消えます）
 * @type switch
 * @default 105
 *
 * @param ウィンドウ接触時不透明度
 * @desc プレイヤーがウィンドウ内に入った時の半透明度
 * @type number
 * @max 255
 * @min 0
 * @default 128
 *
 * @param メッセージ表示中一時消去
 * @type boolean
 * @desc メッセージウィンドウ表示中は所持金ウィンドウを隠す
 * 初期値: ON ( true = ON 隠す / false = OFF 隠さない )
 * @default false
 *
 * @param イベント起動中一時消去
 * @type boolean
 * @desc イベント起動中は所持金ウィンドウを隠す
 * 初期値: ON（ true = ON 隠す / false = OFF 隠さない )
 * @default false
 *
 * @help  
 * プラグインコマンド
 * 金額ウィンドウ表示 :金額ウィンドウを表示します
 * 金額ウィンドウ非表示 :金額ウィンドウを非表示にします
 *
 */
 
function Game_SyakinWindow() 
{
    this.initialize.apply(this, arguments);
}

( function() 
{
	var parameters = PluginManager.parameters('GoldWindows');
	
	params = [];
	
	//ウィンドウ系
	params.xPos = Number( parameters['ウィンドウX座標'] || 636 );
	params.yPos = Number( parameters['ウィンドウY座標'] || 0 );
	params.width = Number( parameters['ウィンドウ幅'] || 180 );
	params.height = Number( parameters['ウィンドウ高さ'] || 80 );
	params.alfa = Number( parameters['ウィンドウ接触時不透明度'] || 128 );
	params.visibleSw = Number( parameters['表示・非表示スイッチ'] || 105 );
	
	params.nowMonneyText = String( parameters['所持金文字'] || '所持金' );
	
	params.messageBusy = JSON.parse(parameters['メッセージ表示中一時消去'] || 'false');
	params.eventBusy = JSON.parse(parameters['イベント起動中一時消去'] || 'false');
	
	//-----------------------------------------------------------------------------
	// Scene_Map
	//
	var isEnabled = false;
	
	var _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
	Scene_Map.prototype.createDisplayObjects = function() 
	{
		_Scene_Map_createDisplayObjects.call(this);
		this.Game_SyakinWindow();
	};

	//借金ウィンドウの作成
	Scene_Map.prototype.Game_SyakinWindow = function() {
		this._Game_SyakinWindow = new Game_SyakinWindow();
		this.addChild(this._Game_SyakinWindow);
		
	};
	
	var _Scene_Map_terminate = Scene_Map.prototype.terminate;
	Scene_Map.prototype.terminate = function() {
	if (!SceneManager.isNextScene(Scene_Battle)) {
	  this._Game_SyakinWindow.hide();
	}
	_Scene_Map_terminate.call(this);
	};

	var _Scene_Map_launchBattle = Scene_Map.prototype.launchBattle;
	Scene_Map.prototype.launchBattle = function() {
		this._Game_SyakinWindow.hide();
		this.removeChild(this._Game_SyakinWindow);
		this._Game_SyakinWindow = null;
		_Scene_Map_launchBattle.call(this);
	};
  
	/*以下借金ウィンドウ作成処理*/
	
	//借金ウィンドウ
	//-----------------------------------------------------------------------------
	// Game_SyakinWindow
	//
	function _Game_SyakinWindow() 
	{
		this.initialize.apply(this, arguments);
	}
	
	Game_SyakinWindow.prototype = Object.create(Window_Base.prototype);
	Game_SyakinWindow.prototype.constructor = Game_SyakinWindow;
	
	Game_SyakinWindow.prototype.initialize = function() {
	
	/*ウィンドウ描画の為の設定*/
	var wight  = params.width;
	var height = params.height;
	var x      = params.xPos;
	var y      = params.yPos;
	this._isEnabled = false;
	Window_Base.prototype.initialize.call(this, x, y, wight, height);			//ここで描画
	
	this.openness = 0;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
	this.opacity = 198			//半透明度;
	this.contentsOpacity = 255;
	
	this._baseX = x;
	this._needFaceRefresh = false;
	
	this._hideCount = 0;
	
	this.refresh();
	};
	
	//フレーム更新
	  Game_SyakinWindow.prototype.update = function() 
	  {
    	Window_Base.prototype.update.call(this);
    	
    	this.contents.clear();							//多分前の描画を消す
    	
    	//else
    	//{
    	//	this.openness = 0;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
    	//}
    	
    	this.updateOpacity();
    	if( this.updateVisibility() )
    	{
    		this.open();
    		if (  $gameSwitches.value(params.visibleSw) )
	    	{
	    		this.drawMonney();
	    		//this.openness = 255;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
	    		
	    		this.updateOpacity();
	    	}
    		 this.refresh();
    	}
    	else
    		this.close();
    }
    
    /**
     * 目標金額描画
     */
    Game_SyakinWindow.prototype.drawMonney = function()
    {
    	this.contents.fontSize = 26;
		
    	var txtSyakinInfo = $gameParty._gold + " " + $dataSystem.currencyUnit;
    	var lblSyakinInfo = params.nowMonneyText;
		//this.contents.fontSize = params.fontSize;
		this.drawText( lblSyakinInfo, 10, 10, params.fontSize * lblSyakinInfo.length );					//文字数分だけ幅を作る
		this.drawText( txtSyakinInfo, 10, 10 + this.contents.fontSize, 150, 'right' );												//ラベル文字数分ずらして残金関連作成
    	
    }
    
	// リフレッシュ
	Game_SyakinWindow.prototype.refresh = function() 
	{
		
	}
	
	/**
	 * 不透明度の更新
	 */
	Game_SyakinWindow.prototype.updateOpacity = function() {
	if (this.x < $gamePlayer.screenX() + 24 &&
	    this.x + params.width > $gamePlayer.screenX() - 24 &&
	    this.y < $gamePlayer.screenY() &&
	    this.y + params.height > $gamePlayer.screenY() - 48) {
	  this.opacity = params.alfa;
	} else {
	  this.opacity = 255;
	  //this.opacity = 0; 								//ウィンドウのopacity
	}
	//this.contentsOpacity = this.opacity;
	this.contentsOpacity = 255;							//内部オブジェクトのopacity
	};

	/**
	 * 表示更新更新
	 */
	Game_SyakinWindow.prototype.updateVisibility = function() 
	{
		//表示スイッチが入ってない時はfalse返す
		if ( !$gameSwitches.value( params.visibleSw ) ) 
		{
			return false;
		}
		
		if ( (params.eventBusy && $gameMap.isEventRunning()) ||
				( params.messageBusy && $gameMessage.isBusy())) {
			this._hideCount++;
		} else {
			this._hideCount = 0;
		}
		return this._hideCount < 10 && $gameParty.leader();
	};
	
	//全体像表示
	Game_SyakinWindow.prototype.standardPadding = function() 
	{
	    return 0;
	};

	//-----------------------------------------------------------------------------
	// Game_Interpreter
	//
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) 
	{
	    _Game_Interpreter_pluginCommand.call(this, command, args);
	    if (command === '金額ウィンドウ表示') 
	    {
	       $gameSwitches.setValue(params.visibleSw, true);
	    } else if (command === '金額ウィンドウ非表示') {
	       $gameSwitches.setValue(params.visibleSw, false);
	      
	    }
	};

})();
